/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.skill;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkillProperties;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.client.render.IOrderedRender;
import dev.toma.gunsrpg.client.screen.skill.IViewContext;
import dev.toma.gunsrpg.client.screen.skill.IViewManager;
import dev.toma.gunsrpg.client.screen.skill.View;
import dev.toma.gunsrpg.client.screen.widgets.FooterWidget;
import dev.toma.gunsrpg.client.screen.widgets.HeaderWidget;
import dev.toma.gunsrpg.client.screen.widgets.PannableWidget;
import dev.toma.gunsrpg.client.screen.widgets.SkillInfoWidget;
import dev.toma.gunsrpg.client.screen.widgets.SkillWidget;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_RequestExtensionSkillLockPacket;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.object.LazyLoader;
import java.util.Comparator;
import javax.annotation.Nullable;
import lib.toma.animations.QuickSort;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExtensionsView
extends View {
    private static final ITextComponent TEXT_RESET_SKILLS = new TranslationTextComponent("screen.button.reset_skills");
    private static final ResourceLocation PERKPOINT_BOOK = GunsRPG.makeResource("textures/item/perkpoint_book.png");
    private final View last;
    private final SkillType<?> head;
    private PannableWidget canvas;
    private FooterWidget footer;
    private SkillInfoWidget skillInfo;
    private SimpleButton reset;

    public ExtensionsView(int width, int height, IViewManager manager, View last, SkillType<?> head) {
        super(width, height, manager);
        this.last = last;
        this.head = head;
    }

    @Override
    protected void init() {
        this.clear();
        this.canvas = this.addWidget(new PannableWidget(this.field_230690_l_, this.field_230691_m_ + 30, this.field_230688_j_, this.field_230689_k_ - 60));
        this.canvas.setEmptyClickResponder(this::skillClicked);
        this.addWidget(new SimpleButton(this.field_230690_l_ + 5, this.field_230691_m_ + 5, 20, 20, this::backButtonClicked));
        TranslationTextComponent title = new TranslationTextComponent("view.extension.header", new Object[]{this.head.getTitle()});
        this.addWidget(new HeaderWidget(this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, 30, (ITextComponent)title, this.font));
        IViewContext context = this.manager.getContext();
        IPlayerData data = context.getData();
        ISkillProperties properties = this.head.getHierarchy().getExtensions()[0].getProperties();
        ITransactionValidator validator = properties.getTransactionValidator();
        ReadOnlyPointProvider pointProvider = new ReadOnlyPointProvider(validator, data);
        this.footer = this.addWidget(new FooterWidget(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 20, this.field_230688_j_, 20, this.font, pointProvider));
        this.footer.setColorSchema(0xFFFF00, 0xCCCC00);
        this.skillInfo = this.addWidget(new SkillInfoWidget(this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_ - 80, this.field_230688_j_, 80, this.manager));
        this.reset = this.addWidget(new SimpleButton(this.field_230690_l_ + this.field_230688_j_ - 75, this.field_230691_m_ + 5, 70, 20, TEXT_RESET_SKILLS, this::resetSkillsClicked, this::renderResetSkillsButtonTooltip));
        this.showSkills();
        this.setSkillInfoVisibility(false);
        this.sortRenderOrder();
    }

    private void skillClicked(@Nullable SkillType<?> type) {
        this.skillInfo.updateSource(type);
        this.setSkillInfoVisibility(type != null);
    }

    private void backButtonClicked(Button button) {
        this.manager.setView(this.last);
    }

    private void showSkills() {
        this.canvas.fill(this::placeSkills);
        this.updateResetButtonState();
    }

    private void placeSkills(PannableWidget.IContentManager manager, int x, int y) {
        IViewContext context = this.manager.getContext();
        int index = 0;
        int level = 0;
        int posY = y;
        SkillType<?>[] ext = this.head.getHierarchy().getExtensions();
        QuickSort.sort(ext, Comparator.comparing(SkillType::getProperties, Comparator.comparingInt(ISkillProperties::getRequiredLevel)).thenComparing(ForgeRegistryEntry::getRegistryName));
        for (SkillType<?> type : ext) {
            ISkillProperties properties = type.getProperties();
            int lvl = properties.getRequiredLevel();
            if (lvl > level) {
                level = lvl;
                posY += 40;
                index = 0;
            }
            SkillWidget widget = manager.add(new SkillWidget(x + 40 + index++ * 35, 30 + posY, 22, 22, type, context, false));
            widget.setClickResponder(this::skillClicked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSkillInfoVisibility(boolean visibility) {
        Object object = this.lock;
        synchronized (object) {
            this.footer.field_230694_p_ = !visibility;
            this.skillInfo.field_230694_p_ = visibility;
            this.canvas.updateSize(this.field_230688_j_, this.field_230689_k_ - (visibility ? 110 : 50));
        }
    }

    private void resetSkillsClicked(Button button) {
        NetworkManager.sendServerPacket(new C2S_RequestExtensionSkillLockPacket(this.head));
        this.init();
    }

    private void updateResetButtonState() {
        SkillType<?>[] extensions;
        IPlayerData data = this.manager.getContext().getData();
        IPerkProvider provider = data.getPerkProvider();
        boolean hasFunds = provider.getPoints() >= 25;
        ISkillProvider skillProvider = data.getSkillProvider();
        boolean hasAnySkill = false;
        for (SkillType<?> type : extensions = this.head.getHierarchy().getExtensions()) {
            if (!skillProvider.hasSkill(type)) continue;
            hasAnySkill = true;
            break;
        }
        this.reset.field_230693_o_ = hasAnySkill && hasFunds;
    }

    private void renderResetSkillsButtonTooltip(Button button, MatrixStack matrix, int mouseX, int mouseY) {
        int x = mouseX + 12;
        int y = mouseY - 12;
        int z = 400;
        String text = String.valueOf(25);
        int tooltipWidth = this.font.func_78256_a(text) + 25;
        int tooltipHeight = 20;
        if (x + tooltipWidth > this.field_230688_j_) {
            x -= 28 + tooltipWidth;
        }
        if (y + tooltipHeight > this.field_230689_k_) {
            y = this.field_230689_k_ - tooltipHeight;
        }
        int color1 = -267386864;
        int color2 = 0x505000FF;
        int color3 = 1344798847;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        matrix.func_227860_a_();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y - 4), (int)(x + tooltipWidth + 3), (int)(y - 3), (int)z, (int)color1, (int)color1);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y + tooltipHeight + 3), (int)(x + tooltipWidth + 3), (int)(y + tooltipHeight + 4), (int)z, (int)color1, (int)color1);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y - 3), (int)(x + tooltipWidth + 3), (int)(y + tooltipHeight + 3), (int)z, (int)color1, (int)color1);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + tooltipHeight + 3), (int)z, (int)color1, (int)color1);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x + tooltipWidth + 3), (int)(y - 3), (int)(x + tooltipWidth + 4), (int)(y + tooltipHeight + 3), (int)z, (int)color1, (int)color1);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + tooltipHeight + 3 - 1), (int)400, (int)color2, (int)color3);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x + tooltipWidth + 2), (int)(y - 3 + 1), (int)(x + tooltipWidth + 3), (int)(y + tooltipHeight + 3 - 1), (int)z, (int)color2, (int)color3);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y - 3), (int)(x + tooltipWidth + 3), (int)(y - 3 + 1), (int)z, (int)color2, (int)color2);
        ExtensionsView.func_238462_a_((Matrix4f)pose, (BufferBuilder)builder, (int)(x - 3), (int)(y + tooltipHeight + 2), (int)(x + tooltipWidth + 3), (int)(y + tooltipHeight + 3), (int)z, (int)color3, (int)color3);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_227888_a_(pose, (float)(x + tooltipWidth - 20), (float)(y + 2), (float)z).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(pose, (float)(x + tooltipWidth - 20), (float)(y + 18), (float)z).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, (float)(x + tooltipWidth - 2), (float)(y + 18), (float)z).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(pose, (float)(x + tooltipWidth - 2), (float)(y + 2), (float)z).func_225583_a_(1.0f, 0.0f).func_181675_d();
        this.client.func_110434_K().func_110577_a(PERKPOINT_BOOK);
        tessellator.func_78381_a();
        IRenderTypeBuffer.Impl typeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)builder);
        matrix.func_227861_a_(0.0, 0.0, (double)z);
        this.font.func_228079_a_(text, (float)x + (float)(16 - this.font.func_78256_a(text)) / 2.0f, (float)y + (float)(tooltipHeight - 9) / 2.0f, -1, true, pose, (IRenderTypeBuffer)typeBuffer, false, 0, 0xF000F0);
        typeBuffer.func_228461_a_();
        matrix.func_227865_b_();
    }

    private static class ReadOnlyPointProvider
    implements IKillData {
        private final LazyLoader<IKillData> loader = new LazyLoader<IKillData>(() -> validator.getData(data));

        public ReadOnlyPointProvider(ITransactionValidator validator, IPlayerData data) {
        }

        @Override
        public int getPoints() {
            return this.loader.get().getPoints();
        }

        @Override
        public int getLevel() {
            return this.loader.get().getLevel();
        }

        @Override
        public int getKills() {
            return this.loader.get().getKills();
        }

        @Override
        public int getRequiredKillCount() {
            return this.loader.get().getRequiredKillCount();
        }

        @Override
        public int getLevelLimit() {
            return this.loader.get().getLevelLimit();
        }

        @Override
        public void addLevels(int levels) {
            throw new UnsupportedOperationException("Cannot perform this operation on read-only provider");
        }

        @Override
        public void advanceLevel(boolean notify) {
            throw new UnsupportedOperationException("Cannot perform this operation on read-only provider");
        }

        @Override
        public void onEnemyKilled(Entity enemy, ItemStack weapon) {
            throw new UnsupportedOperationException("Cannot perform this operation on read-only provider");
        }

        @Override
        public void awardPoints(int amount) {
            throw new UnsupportedOperationException("Cannot perform this operation on read-only provider");
        }
    }

    private static class SimpleButton
    extends Button
    implements IOrderedRender {
        SimpleButton(int x, int y, int width, int height, Button.IPressable clickEvent) {
            this(x, y, width, height, (ITextComponent)new StringTextComponent("<<<"), clickEvent, (button, matrix, mouseX, mouseY) -> {});
        }

        SimpleButton(int x, int y, int width, int height, ITextComponent component, Button.IPressable clickEvent, Button.ITooltip tooltip) {
            super(x, y, width, height, component, clickEvent, tooltip);
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230692_n_) {
                RenderUtils.drawSolid(matrix.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 0x66FFFFFF);
            }
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            RenderUtils.drawCenteredShadowText(matrix, this.func_230458_i_(), renderer, (Widget)this, this.field_230693_o_ ? 0xFFFFFF : 0x888888);
            if (this.field_230692_n_) {
                this.func_230443_a_(matrix, mouseX, mouseY);
            }
        }

        @Override
        public int getRenderIndex() {
            return 1;
        }
    }
}

